package w83b.w83bOperacionesPaso.w83bHistoricos;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bHistoricosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bOperacionesPaso.w83bResultados.W83bTablaCuadroResultadosExcelAction;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bCrearDelegAgrupConvHistAction extends Q70ActionPasoOP{
	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
	}
	

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bHistDelegAgrupConv.xls";
		InputStream inputStream = W83bTablaCuadroResultadosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List losDatos = (ArrayList)contexto.get("w83bResultadoHistorico");
        List totales = (ArrayList)losDatos.get(losDatos.size()-1);
      
        HSSFCellStyle sinBordeAbajo = this.sinBordeAbajo(wb);
        HSSFCellStyle normalCentrado = this.normalCentrado(wb);
        HSSFCellStyle normalCentradoSinBordes = this.normalCentradoSinBordes(wb);
        HSSFCellStyle normalNumero = this.normalNumero(wb);
        HSSFCellStyle normalLetra = this.normalLetra(wb);
        HSSFCellStyle normalLetraNegrita = this.normalLetraNegrita(wb);
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
      
        
        W83bHistoricosBean losCriterios = (W83bHistoricosBean)losDatos.get(0); 
        
       	String territorio = "";
        if (losCriterios.getTerritorio()== null || "".equals(losCriterios.getTerritorio()) || "null".equals(losCriterios.getTerritorio())){
        	territorio = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.comautvascaentero",idioma);
        }
        else{
        	territorio = losCriterios.getDescTerritorio().toUpperCase();
        }
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
         
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma)); 
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        
        HSSFRow laRowA = sheet.getRow((short)4); 
        HSSFCell cell = laRowA.getCell((short)5);
        HSSFCell cell2;
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = laRowA.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }        
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }
                
        laRowA = sheet.getRow((short)6); 
        cell = laRowA.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = laRowA.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        laRowA = sheet.getRow((short)9); 
        cell = laRowA.getCell((short)0);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.delegAgrupConvHist").toUpperCase());
        
        laRowA = sheet.getRow((short)10); 
        cell = laRowA.getCell((short)0);
        cell.setCellValue(territorio+"-"+losCriterios.getMes()+"/"+losCriterios.getAnyo());
        cell.setCellStyle(normalCentradoSinBordes);
        
        W83bHistoricosBean elDato = new W83bHistoricosBean();
        String agrupacionAnterior = "";
        String convenioAnterior = "";
        
        int fila=9;
        if (losCriterios.getTerritorio()== null || "".equals(losCriterios.getTerritorio()) || "null".equals(losCriterios.getTerritorio())){
	        for (int i=0;i<(losDatos.size()-1);i++){
	        	 elDato = (W83bHistoricosBean)losDatos.get(i);
	        	 if(!agrupacionAnterior.equals(elDato.getCodAgrupacion())){
	        		 
	        		 if(i!=0){
	        			 fila=fila+2;
	        			 W83bHistoricosBean elDatoAnterior = (W83bHistoricosBean)losDatos.get(i-1);
	        			 W83bHistoricosBean elTotal = new W83bHistoricosBean();//NOPMD
	        			 laRowA = sheet.createRow((short)fila); 
	            		 cell = laRowA.createCell((short)1); 
	            		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.total").toUpperCase());
	            		 sheet.addMergedRegion(new Region(fila,Short.parseShort("1"),fila,Short.parseShort("4")));//NOPMD
	            		 cell.setCellStyle(normalLetraNegrita);
	    	    	     for (int j=0;j<totales.size();j++){
	    	    	    	 elTotal = (W83bHistoricosBean)totales.get(j);
	    	    	    	 
	    	    	    	 if(elTotal.getCodAgrupacion().equals(elDatoAnterior.getCodAgrupacion())){        			    	    	    
	    	    	    		 laRowA = sheet.createRow((short)fila);
			            		 cell = laRowA.createCell((short)5); 
			            		 cell.setCellValue(this.numero(elTotal.getSindicato80()));
			            		 cell.setCellStyle(normalNumero);
			            		 cell = laRowA.createCell((short)6); 
			            		 cell.setCellValue(elTotal.getSiglas());
			            		 cell.setCellStyle(normalLetra);
			            		 cell = laRowA.createCell((short)7); 
			            		 cell.setCellValue(this.numero(elTotal.getAlava()));
			            		 cell.setCellStyle(normalNumero);
			            		 cell = laRowA.createCell((short)8); 
			            		 cell.setCellValue(calcularPorcentaje(elTotal.getAlava(), elTotal.getTotalAlava()));
			            		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
			            		 cell = laRowA.createCell((short)9); 
			            		 cell.setCellValue(this.numero(elTotal.getBizkaia()));
			            		 cell.setCellStyle(normalNumero);
			            		 cell = laRowA.createCell((short)10); 
			            		 cell.setCellValue(calcularPorcentaje(elTotal.getBizkaia(), elTotal.getTotalBizkaia()));
			            		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
			            		 cell = laRowA.createCell((short)11); 
			            		 cell.setCellValue(this.numero(elTotal.getGipuzkoa()));
			            		 cell.setCellStyle(normalNumero);
			            		 cell = laRowA.createCell((short)12); 
			            		 cell.setCellValue(calcularPorcentaje(elTotal.getGipuzkoa(), elTotal.getTotalGipuzkoa()));
			            		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
			            		 cell = laRowA.createCell((short)13); 
			            		 cell.setCellFormula("H"+(fila+1)+"+J"+(fila+1)+"+L"+(fila+1));
			            		 cell.setCellStyle(normalNumero);
			            		 int totalCAV = (new Integer(elTotal.getAlava())).intValue()+(new Integer(elTotal.getBizkaia())).intValue()+(new Integer(elTotal.getGipuzkoa())).intValue();//NOPMD
			            		 cell = laRowA.createCell((short)14); 
			            		 cell.setCellValue(calcularPorcentaje(totalCAV+"",elTotal.getTotalCAV()));
			            		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
			            		 
			            		 fila++;
	    	    	    	 }
	    	    	     }
	    	    	     if(fila<55){
	    	    				 fila = 52;
		    			 }else{
		    				int div = ((fila-54)/44)+1;
		    	     	    fila = 52+(44*(div)); 
		    			 }
	        		 }
	        		 
	        		 
	        		 fila=fila+4;
	        		 laRowA = sheet.createRow((short)fila); 
	        		 cell = laRowA.createCell((short)2); 
	        		 cell2 = laRowA.createCell((short)3); 
	        		 sheet.addMergedRegion(new Region(fila,Short.parseShort("2"),fila,Short.parseShort("3")));//NOPMD
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.agrupacion").toUpperCase());
	        		 cell.setCellStyle(sinBordeAbajo);
	        		 cell2.setCellStyle(sinBordeAbajo);
	        		 cell = laRowA.createCell((short)4); 
	        		 cell.setCellValue(elDato.getCodAgrupacion()+"-"+elDato.getDescAgrupacion());
	        		 cell.setCellStyle(sinBordeAbajo);
	        		 
	        		 fila=fila+2;
	        		 laRowA = sheet.createRow((short)fila); 
	        		 cell = laRowA.createCell((short)5); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.certificaciones.centralSindical").toUpperCase());
	        	     sheet.addMergedRegion(new Region(fila,Short.parseShort("5"),fila,Short.parseShort("6")));//NOPMD
	        		 cell.setCellStyle(normalCentradoSinBordes);
	        		 cell = laRowA.createCell((short)7); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.alava").toUpperCase());
	        		 sheet.addMergedRegion(new Region(fila,Short.parseShort("7"),fila,Short.parseShort("8")));//NOPMD
	        		 cell.setCellStyle(normalCentradoSinBordes);
	        		 cell = laRowA.createCell((short)9); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.bizkaia").toUpperCase());
	        		 sheet.addMergedRegion(new Region(fila,Short.parseShort("9"),fila,Short.parseShort("10")));//NOPMD
	        		 cell.setCellStyle(normalCentradoSinBordes);
	        		 cell = laRowA.createCell((short)11); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.gipuzkoa").toUpperCase());
	        		 sheet.addMergedRegion(new Region(fila,Short.parseShort("11"),fila,Short.parseShort("12")));//NOPMD
	        		 cell.setCellStyle(normalCentradoSinBordes);
	        		 cell = laRowA.createCell((short)13); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.cav").toUpperCase());
	        		 sheet.addMergedRegion(new Region(fila,Short.parseShort("13"),fila,Short.parseShort("14")));//NOPMD
	        		 cell.setCellStyle(normalCentradoSinBordes);
	        		 
	        		 fila++;
	        		 laRowA = sheet.createRow((short)fila); 
	        		 cell = laRowA.createCell((short)1); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.denominacionconvenio").toUpperCase());
	        		 sheet.addMergedRegion(new Region(fila,Short.parseShort("1"),fila,Short.parseShort("4")));//NOPMD
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)2);
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)3);
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)4);
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)5); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.cod").toUpperCase());
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)6); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.siglas").toUpperCase());
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)7); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.num").toUpperCase());
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)8); 
	        		 cell.setCellValue("%");
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)9); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.num").toUpperCase());
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)10); 
	        		 cell.setCellValue("%");
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)11); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.num").toUpperCase());
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)12); 
	        		 cell.setCellValue("%");
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)13); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.num").toUpperCase());
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)14); 
	        		 cell.setCellValue("%");
	        		 cell.setCellStyle(normalCentrado);
	        	 }
	        	 
	        	 agrupacionAnterior=elDato.getCodAgrupacion();
	        	 if(!convenioAnterior.equals(elDato.getConvenio80())){
	        		fila=fila+2; 
	        	 }else{
	        		 fila++;
	        	 }
	    		 laRowA = sheet.createRow((short)fila); 
	    		 cell = laRowA.createCell((short)1); 
	    		 if(!convenioAnterior.equals(elDato.getConvenio80())){
	    			 cell.setCellValue(elDato.getConvenioTxt());
	    		 }
	    		 sheet.addMergedRegion(new Region(fila,Short.parseShort("1"),fila,Short.parseShort("4")));//NOPMD
	    		 cell.setCellStyle(normalLetra);
	    		 cell = laRowA.createCell((short)5); 
	    		 cell.setCellValue(this.numero(elDato.getSindicato80()));
	    		 cell.setCellStyle(normalNumero);
	    		 cell = laRowA.createCell((short)6); 
	    		 cell.setCellValue(elDato.getSiglas());
	    		 cell.setCellStyle(normalLetra);
	    		 cell = laRowA.createCell((short)7); 
	    		 cell.setCellValue(this.numero(elDato.getAlava()));
	    		 cell.setCellStyle(normalNumero);
	    		 cell = laRowA.createCell((short)8); 
	    		 cell.setCellValue(calcularPorcentaje(elDato.getAlava(), elDato.getTotalAlava()));
	    		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
	    		 cell = laRowA.createCell((short)9); 
	    		 cell.setCellValue(this.numero(elDato.getBizkaia()));
	    		 cell.setCellStyle(normalNumero);
	    		 cell = laRowA.createCell((short)10); 
	    		 cell.setCellValue(calcularPorcentaje(elDato.getBizkaia(), elDato.getTotalBizkaia()));
	    		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
	    		 cell = laRowA.createCell((short)11); 
	    		 cell.setCellValue(this.numero(elDato.getGipuzkoa()));
	    		 cell.setCellStyle(normalNumero);
	    		 cell = laRowA.createCell((short)12); 
	    		 cell.setCellValue(calcularPorcentaje(elDato.getGipuzkoa(), elDato.getTotalGipuzkoa()));
	    		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
	    		 cell = laRowA.createCell((short)13); 
	    		 cell.setCellFormula("H"+(fila+1)+"+J"+(fila+1)+"+L"+(fila+1));
	    		 cell.setCellStyle(normalNumero);
	    		 int totalCAV = (new Integer(elDato.getAlava())).intValue()+(new Integer(elDato.getBizkaia())).intValue()+(new Integer(elDato.getGipuzkoa())).intValue();//NOPMD
	    		 cell = laRowA.createCell((short)14); 
	    		 cell.setCellValue(calcularPorcentaje(totalCAV+"",elDato.getTotalCAV()));
	    		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
	    		 
	    		 convenioAnterior=elDato.getConvenio80();
	        	
	        }
	        

			 fila=fila+2;
			
			 W83bHistoricosBean elTotalA = new W83bHistoricosBean();//NOPMD
			 laRowA = sheet.createRow((short)fila); 
	   		 cell = laRowA.createCell((short)1); 
	   		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.total").toUpperCase());
	   		 sheet.addMergedRegion(new Region(fila,Short.parseShort("1"),fila,Short.parseShort("4")));//NOPMD
	   		 cell.setCellStyle(normalLetraNegrita);
	   	     for (int j=0;j<totales.size();j++){
	   	    	elTotalA = (W83bHistoricosBean)totales.get(j);
   	    	 
   	    	 if(elTotalA.getCodAgrupacion().equals(elDato.getCodAgrupacion())){        			    	    	    
   	    		 laRowA = sheet.createRow((short)fila);
           		 cell = laRowA.createCell((short)5); 
           		 cell.setCellValue(this.numero(elTotalA.getSindicato80()));
           		 cell.setCellStyle(normalNumero);
           		 cell = laRowA.createCell((short)6); 
           		 cell.setCellValue(elTotalA.getSiglas());
           		 cell.setCellStyle(normalLetra);
           		 cell = laRowA.createCell((short)7); 
           		 cell.setCellValue(this.numero(elTotalA.getAlava()));
           		 cell.setCellStyle(normalNumero);
           		 cell = laRowA.createCell((short)8); 
           		 cell.setCellValue(calcularPorcentaje(elTotalA.getAlava(), elTotalA.getTotalAlava()));
           		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
           		 cell = laRowA.createCell((short)9); 
           		 cell.setCellValue(this.numero(elTotalA.getBizkaia()));
           		 cell.setCellStyle(normalNumero);
           		 cell = laRowA.createCell((short)10); 
           		 cell.setCellValue(calcularPorcentaje(elTotalA.getBizkaia(), elTotalA.getTotalBizkaia()));
           		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
           		 cell = laRowA.createCell((short)11); 
           		 cell.setCellValue(this.numero(elTotalA.getGipuzkoa()));
           		 cell.setCellStyle(normalNumero);
           		 cell = laRowA.createCell((short)12); 
           		 cell.setCellValue(calcularPorcentaje(elTotalA.getGipuzkoa(), elTotalA.getTotalGipuzkoa()));
           		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
           		 cell = laRowA.createCell((short)13); 
           		 cell.setCellFormula("H"+(fila+1)+"+J"+(fila+1)+"+L"+(fila+1));
           		 cell.setCellStyle(normalNumero);
           		 int totalCAV = (new Integer(elTotalA.getAlava())).intValue()+(new Integer(elTotalA.getBizkaia())).intValue()+(new Integer(elTotalA.getGipuzkoa())).intValue();//NOPMD
           		 cell = laRowA.createCell((short)14); 
           		 cell.setCellValue(calcularPorcentaje(totalCAV+"",elTotalA.getTotalCAV()));
           		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
           		 
           		 fila++;
   	    	 }
   	     }
		 
        }else{

	        for (int i=0;i<(losDatos.size()-1);i++){
	        	 elDato = (W83bHistoricosBean)losDatos.get(i);
	        	 if(!agrupacionAnterior.equals(elDato.getCodAgrupacion())){
	        		 
	        		 if(i!=0){
	        			 fila=fila+2;
	        			 W83bHistoricosBean elDatoAnterior = (W83bHistoricosBean)losDatos.get(i-1);
	        			 W83bHistoricosBean elTotal = new W83bHistoricosBean();//NOPMD
	        			 laRowA = sheet.createRow((short)fila); 
	            		 cell = laRowA.createCell((short)2); 
	            		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.total").toUpperCase());
	            		 sheet.addMergedRegion(new Region(fila,Short.parseShort("2"),fila,Short.parseShort("6")));//NOPMD
	            		 cell.setCellStyle(normalLetraNegrita);
	            		
	    	    	     for (int j=0;j<totales.size();j++){
	    	    	    	 elTotal = (W83bHistoricosBean)totales.get(j);
	    	    	    	 
	    	    	    	 if(elTotal.getCodAgrupacion().equals(elDatoAnterior.getCodAgrupacion())){        			    	    	    
	    	    	    		 laRowA = sheet.createRow((short)fila);
			            		 cell = laRowA.createCell((short)7); 
			            		 cell.setCellValue(this.numero(elTotal.getSindicato80()));
			            		 cell.setCellStyle(normalNumero);
			            		 cell = laRowA.createCell((short)8); 
			            		 cell.setCellValue(elTotal.getDescSindicato());
			            		 sheet.addMergedRegion(new Region(fila,Short.parseShort("8"),fila,Short.parseShort("12")));//NOPMD
			            		 cell.setCellStyle(normalLetra);
			            		 
			            		 if("20".equals(losCriterios.getTerritorio())){
				            		 cell = laRowA.createCell((short)13); 
				            		 cell.setCellValue(this.numero(elTotal.getGipuzkoa()));
				            		 cell.setCellStyle(normalNumero);
				            		 cell = laRowA.createCell((short)14); 
				            		 cell.setCellValue(calcularPorcentaje(elTotal.getGipuzkoa(), elTotal.getTotalGipuzkoa()));
				            		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
			            		 }else if("48".equals(losCriterios.getTerritorio())){
				            		 cell = laRowA.createCell((short)13); 
				            		 cell.setCellValue(this.numero(elTotal.getBizkaia()));
				            		 cell.setCellStyle(normalNumero);
				            		 cell = laRowA.createCell((short)14); 
				            		 cell.setCellValue(calcularPorcentaje(elTotal.getBizkaia(), elTotal.getTotalBizkaia()));
				            		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
			            		 }else{
			            			 cell = laRowA.createCell((short)13); 
				            		 cell.setCellValue(this.numero(elTotal.getAlava()));
				            		 cell.setCellStyle(normalNumero);
				            		 cell = laRowA.createCell((short)14); 
				            		 cell.setCellValue(calcularPorcentaje(elTotal.getAlava(), elTotal.getTotalAlava()));
				            		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
			            		 }
			            		
			            		 fila++;
	    	    	    	 }
	    	    	     }
	    	    	     if(fila<55){
    	    				 fila = 52;
		    			 }else{
		    				int div = ((fila-54)/44)+1;
		    	     	    fila = 52+(44*(div)); 
		    			 }
	        		 }
	        		 
	        		 
	        		 fila=fila+4;
	        		 laRowA = sheet.createRow((short)fila); 
	        		 cell = laRowA.createCell((short)2); 
	        		 cell2 = laRowA.createCell((short)3); 
	        		 sheet.addMergedRegion(new Region(fila,Short.parseShort("2"),fila,Short.parseShort("3")));//NOPMD
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.agrupacion").toUpperCase());
	        		 cell.setCellStyle(sinBordeAbajo);
	        		 cell2.setCellStyle(sinBordeAbajo);
	        		 cell = laRowA.createCell((short)4); 
	        		 cell.setCellValue(elDato.getCodAgrupacion()+"-"+elDato.getDescAgrupacion());
	        		 cell.setCellStyle(sinBordeAbajo);
	        		 
	        		 fila=fila+2;
	        		 laRowA = sheet.createRow((short)fila); 
	        		 cell = laRowA.createCell((short)7); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.certificaciones.centralSindical").toUpperCase());
	        	     sheet.addMergedRegion(new Region(fila,Short.parseShort("7"),fila,Short.parseShort("12")));//NOPMD
	        		 cell.setCellStyle(normalCentradoSinBordes);
	        		 
	        		 cell = laRowA.createCell((short)13); 
	        		 if("20".equals(losCriterios.getTerritorio())){
		        		 cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.gipuzkoa",idioma).toUpperCase());
		        		 
	        		 }else if("48".equals(losCriterios.getTerritorio())){
	        			 cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.bizkaia",idioma).toUpperCase());
		        	 }else{
	        			 cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.alava",idioma).toUpperCase());
		        	 }
	        		 sheet.addMergedRegion(new Region(fila,Short.parseShort("12"),fila,Short.parseShort("13")));//NOPMD
	        		 cell.setCellStyle(normalCentradoSinBordes);
	        		 
	        		 fila++;
	        		 laRowA = sheet.createRow((short)fila); 
	        		 cell = laRowA.createCell((short)2); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.denominacionconvenio").toUpperCase());
	        		 sheet.addMergedRegion(new Region(fila,Short.parseShort("2"),fila,Short.parseShort("6")));//NOPMD
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)3);
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)4);
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)5);
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)6);
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)7); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.cod").toUpperCase());
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)8); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.sindicato").toUpperCase());
	        		 sheet.addMergedRegion(new Region(fila,Short.parseShort("8"),fila,Short.parseShort("12")));//NOPMD
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)9);
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)10);
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)11);
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)12);
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)13); 
	        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.num").toUpperCase());
	        		 cell.setCellStyle(normalCentrado);
	        		 cell = laRowA.createCell((short)14); 
	        		 cell.setCellValue("%");
	        		 cell.setCellStyle(normalCentrado);
	        		
	        	 }
	        	 
	        	 agrupacionAnterior=elDato.getCodAgrupacion();
	        	 if(!convenioAnterior.equals(elDato.getConvenio80())){
	        		fila=fila+2; 
	        	 }else{
	        		 fila++;
	        	 }
	    		 laRowA = sheet.createRow((short)fila); 
	    		 cell = laRowA.createCell((short)2); 
	    		 if(!convenioAnterior.equals(elDato.getConvenio80())){
	    			 cell.setCellValue(elDato.getConvenioTxt());
	    		 }
	    		 sheet.addMergedRegion(new Region(fila,Short.parseShort("2"),fila,Short.parseShort("6")));//NOPMD
	    		 cell.setCellStyle(normalLetra);
	    		 cell = laRowA.createCell((short)7); 
	    		 cell.setCellValue(this.numero(elDato.getSindicato80()));
	    		 cell.setCellStyle(normalNumero);
	    		 cell = laRowA.createCell((short)8); 
	    		 cell.setCellValue(elDato.getDescSindicato());
	    		 sheet.addMergedRegion(new Region(fila,Short.parseShort("8"),fila,Short.parseShort("12")));//NOPMD
	    		 cell.setCellStyle(normalLetra);
	    		 
	    		 
	    		 if("20".equals(losCriterios.getTerritorio())){
	    			 cell = laRowA.createCell((short)13); 
		    		 cell.setCellValue(this.numero(elDato.getGipuzkoa()));
		    		 cell.setCellStyle(normalNumero);
		    		 cell = laRowA.createCell((short)14); 
		    		 cell.setCellValue(calcularPorcentaje(elDato.getGipuzkoa(), elDato.getTotalGipuzkoa()));
		    		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
        		 }else if("48".equals(losCriterios.getTerritorio())){
        			 cell = laRowA.createCell((short)13); 
    	    		 cell.setCellValue(this.numero(elDato.getBizkaia()));
    	    		 cell.setCellStyle(normalNumero);
    	    		 cell = laRowA.createCell((short)14); 
    	    		 cell.setCellValue(calcularPorcentaje(elDato.getBizkaia(), elDato.getTotalBizkaia()));
    	    		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
	        	 }else{
	        		 cell = laRowA.createCell((short)13); 
		    		 cell.setCellValue(this.numero(elDato.getAlava()));
		    		 cell.setCellStyle(normalNumero);
		    		 cell = laRowA.createCell((short)14); 
		    		 cell.setCellValue(calcularPorcentaje(elDato.getAlava(), elDato.getTotalAlava()));
		    		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
	        	 }
	    		 
	    	 
	    		 convenioAnterior=elDato.getConvenio80();
	        	
	        }
        

			 fila=fila+2;
			
			 W83bHistoricosBean elTotal2 = new W83bHistoricosBean();//NOPMD
			 laRowA = sheet.createRow((short)fila); 
	   		 cell = laRowA.createCell((short)2); 
	   		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.total").toUpperCase());
	   		 sheet.addMergedRegion(new Region(fila,Short.parseShort("2"),fila,Short.parseShort("6")));//NOPMD
	   		 cell.setCellStyle(normalLetraNegrita);
	   		
	   	     for (int j=0;j<totales.size();j++){
	   	    	elTotal2 = (W83bHistoricosBean)totales.get(j);
	   	    	 
	   	    	 if(elTotal2.getCodAgrupacion().equals(elDato.getCodAgrupacion())){        			    	    	    
	   	    		 laRowA = sheet.createRow((short)fila);
	           		 cell = laRowA.createCell((short)7); 
	           		 cell.setCellValue(this.numero(elTotal2.getSindicato80()));
	           		 cell.setCellStyle(normalNumero);
	           		 cell = laRowA.createCell((short)8); 
	           		 cell.setCellValue(elTotal2.getDescSindicato());
	           		 sheet.addMergedRegion(new Region(fila,Short.parseShort("8"),fila,Short.parseShort("12")));//NOPMD
	           		 cell.setCellStyle(normalLetra);
	           		 
	           		 if("20".equals(losCriterios.getTerritorio())){
		            		 cell = laRowA.createCell((short)13); 
		            		 cell.setCellValue(this.numero(elTotal2.getGipuzkoa()));
		            		 cell.setCellStyle(normalNumero);
		            		 cell = laRowA.createCell((short)14); 
		            		 cell.setCellValue(calcularPorcentaje(elTotal2.getGipuzkoa(), elTotal2.getTotalGipuzkoa()));
		            		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
	           		 }else if("48".equals(losCriterios.getTerritorio())){
		            		 cell = laRowA.createCell((short)13); 
		            		 cell.setCellValue(this.numero(elTotal2.getBizkaia()));
		            		 cell.setCellStyle(normalNumero);
		            		 cell = laRowA.createCell((short)14); 
		            		 cell.setCellValue(calcularPorcentaje(elTotal2.getBizkaia(), elTotal2.getTotalBizkaia()));
		            		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
	           		 }else{
	           			 cell = laRowA.createCell((short)13); 
		            		 cell.setCellValue(this.numero(elTotal2.getAlava()));
		            		 cell.setCellStyle(normalNumero);
		            		 cell = laRowA.createCell((short)14); 
		            		 cell.setCellValue(calcularPorcentaje(elTotal2.getAlava(), elTotal2.getTotalAlava()));
		            		 cell.setCellStyle(this.stylePorcentajesDcha(excel));
	           		 }
	           		
	           		 fila++;
	   	    	 }
	   	     }
		 
        	
        	
        }
        
       
       
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        String nombreFichero = "listadoDelegAgrupConvenioHistorico.xls";
        response.setHeader("Content-Disposition","attachment; filename=" +nombreFichero);
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();
        
		return null;
	}
	
	
	
	private HSSFCellStyle sinBordeAbajo(HSSFWorkbook wb){
		HSSFCellStyle sinBordeAbajo =  wb.createCellStyle();
		
		sinBordeAbajo = wb.createCellStyle();// Estilo		
		sinBordeAbajo.setAlignment(HSSFCellStyle.ALIGN_LEFT);		
		sinBordeAbajo.setFont(this.negrita(wb));
		return sinBordeAbajo;
		
	}
	
	private HSSFCellStyle normalNumero(HSSFWorkbook wb){
		HSSFCellStyle normalNumero =  wb.createCellStyle();
		
		normalNumero = wb.createCellStyle();// Estilo		
		normalNumero.setAlignment(HSSFCellStyle.ALIGN_RIGHT);	
		normalNumero.setDataFormat((short)3);
		return normalNumero;
		
	}
	private HSSFCellStyle stylePorcentajesDcha(W83bUtilidadesExcel excel){
		return excel.stylePorcentajesDcha;	
	}

	private HSSFCellStyle normalLetra(HSSFWorkbook wb){
		HSSFCellStyle normalLetra =  wb.createCellStyle();
		normalLetra = wb.createCellStyle();// Estilo		
		normalLetra.setAlignment(HSSFCellStyle.ALIGN_LEFT);		
		return normalLetra;
		
	}
	
	private HSSFCellStyle normalLetraNegrita(HSSFWorkbook wb){
		HSSFCellStyle normalLetra =  wb.createCellStyle();
		normalLetra = wb.createCellStyle();// Estilo		
		normalLetra.setAlignment(HSSFCellStyle.ALIGN_LEFT);		
		normalLetra.setFont(this.negrita(wb));
		return normalLetra;
		
	}


	private HSSFCellStyle normalCentrado(HSSFWorkbook wb){
		HSSFCellStyle normal =  wb.createCellStyle();		
		normal = wb.createCellStyle();// Estilo
		normal.setAlignment(HSSFCellStyle.ALIGN_CENTER_SELECTION);
		normal.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		normal.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		normal.setFont(this.negrita(wb));
		return normal;
		
	}

	
	private HSSFCellStyle normalCentradoSinBordes(HSSFWorkbook wb){
		HSSFCellStyle normal =  wb.createCellStyle();		
		normal = wb.createCellStyle();// Estilo
		normal.setAlignment(HSSFCellStyle.ALIGN_CENTER_SELECTION);	
		normal.setFont(this.negrita(wb));
		return normal;
		
	}
	
	
	private HSSFFont negrita (HSSFWorkbook wb){
		
		HSSFFont fuente = wb.createFont();
		fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		
		return fuente;
		
	}	
	
	private int numero(String num){		
		Integer n = new Integer(num);
		return n.intValue();
	}
	
	private float calcularPorcentaje(String totalParcial,String total){
		
		Integer parcial=new Integer(totalParcial);
		Integer totalT=new Integer(total);

		
		if (totalT.intValue()==0){
			return 0;
		}
		else{
			return((float)parcial.intValue())/(float)totalT.intValue();			
		}
	}
	
}